<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: POST");

$file = __DIR__ . "/config.json";

// ===============================
// 1. Jika file belum ada → buat default baru
// ===============================
if (!file_exists($file)) {
    file_put_contents($file, json_encode([
        "site_name"        => "My Store",
        "accent"           => "#d4af37",
        "font_color"       => "#000000",

        "custom_head"        => "",
        "custom_body_top"    => "",
        "custom_body_bottom" => "",
        "custom_footer"      => ""
    ], JSON_PRETTY_PRINT));
}

$config = json_decode(file_get_contents($file), true);
if (!is_array($config)) $config = [];

// ===============================
// 2. Ambil request JSON
// ===============================
$raw = file_get_contents("php://input");
$req = json_decode($raw, true);

if (!$req) {
    echo json_encode([
        "status"  => false,
        "message" => "Invalid JSON payload."
    ]);
    exit;
}

// ===============================
// 3. Field yang boleh diupdate
// ===============================
$allowed = [
    "site_name",
    "accent",
    "font_color",

    "custom_head",
    "custom_body_top",
    "custom_body_bottom",
    "custom_footer",

    "footer_copyright"
];

foreach ($allowed as $key) {
    if (array_key_exists($key, $req)) {
        $config[$key] = $req[$key]; // HTML tidak di-trim agar tidak error
    }
}

// ===============================
// 4. Simpan perubahan
// ===============================
file_put_contents($file, json_encode($config, JSON_PRETTY_PRINT));

echo json_encode([
    "status" => true,
    "message" => "Configuration saved.",
    "config" => $config
]);
