<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: POST");

$file = __DIR__ . "/categories.json";

    // ==================================
    // 1. Ensure JSON file exists
    // ==================================
    if (!file_exists($file)) {
        file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
    }
    
    $dataList = json_decode(file_get_contents($file), true);
    if (!is_array($dataList)) $dataList = [];
    
    // ==================================
    // 2. Read JSON request
    // ==================================
    $raw = file_get_contents("php://input");
    $req = json_decode($raw, true);
    
    if (!$req || empty($req["name"])) {
        echo json_encode([
            "status" => false,
            "message" => "Category name is required."
        ]);
        exit;
    }
    
    $name = trim($req["name"]);
    $id   = isset($req["id"]) ? intval($req["id"]) : null;
    
    // ========== NORMALISASI SUBS (FINAL VERSI BENAR) ==========
    $subs = [];
    
    if (isset($req["subs"]) && is_array($req["subs"])) {
        // array → bersihkan satu per satu
        $subs = array_values(array_filter(array_map('trim', $req["subs"])));
    }
    elseif (isset($req["subs"]) && is_string($req["subs"])) {
        // string "a, b, c" → split → array
        $subs = array_values(array_filter(array_map('trim', explode(',', $req["subs"]))));  
    }
    
    // ==================================
    // 3. UPDATE CATEGORY
    // ==================================
    if ($id !== null) {
    
        $found = false;
    
        foreach ($dataList as &$cat) {
            if ($cat["id"] == $id) {
                $cat["name"] = $name;
                $cat["subs"] = $subs;
                $found = true;
                break;
            }
        }
    
        if (!$found) {
            echo json_encode([
                "status" => false,
                "message" => "Category not found."
            ]);
            exit;
        }
    
        file_put_contents($file, json_encode($dataList, JSON_PRETTY_PRINT));
    
        echo json_encode([
            "status" => true,
            "message" => "Category updated.",
            "categories" => $dataList
        ]);
        exit;
    }


// ==================================
// 4. CREATE NEW CATEGORY
// ==================================
$newId = count($dataList) > 0 
    ? max(array_column($dataList, "id")) + 1 
    : 1;

$newCat = [
    "id"   => $newId,
    "name" => $name,
    "subs" => $subs
];

$dataList[] = $newCat;

file_put_contents($file, json_encode($dataList, JSON_PRETTY_PRINT));

echo json_encode([
    "status" => true,
    "message" => "Category added.",
    "category" => $newCat,
    "categories" => $dataList
]);
