<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$stripeSecret = "sk_test_51SbFDrFawUqu0aCku1bvrTb3aSABnDDfdcsXT5ziFbx0ujBpuYV90gCKew1cjrGwa4B0rVgsKAZTzDKzpz5vZ3K3002d6iDM7U";

// Validate input
if (!isset($_GET["cs"])) {
    echo json_encode(["error" => "Missing client_secret"]);
    exit;
}

$clientSecret = $_GET["cs"];

// Extract PI ID
$parts = explode("_secret_", $clientSecret);
$paymentIntentId = $parts[0];

if (strpos($paymentIntentId, "pi_") !== 0) {
    echo json_encode(["error" => "Invalid PaymentIntent ID"]);
    exit;
}

// Retrieve PI
$url = "https://api.stripe.com/v1/payment_intents/" . $paymentIntentId;

$ch = curl_init($url);
curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_USERPWD => $stripeSecret . ":"
]);

$res = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http >= 400) {
    echo json_encode([
        "error" => "Stripe API error",
        "http" => $http,
        "raw" => json_decode($res, true)
    ]);
    exit;
}

$pi = json_decode($res, true);

// Items decode
$items = json_decode($pi["metadata"]["items"] ?? "[]", true);

// Normalisasi Items
foreach ($items as &$i) {
    $i["variant_color"] = $i["variant_color"] ?? null;
    $i["variant_size"]  = $i["variant_size"] ?? null;
    $i["img"]           = $i["img"] ?? null;
}

// Final Response
$response = [
    "id"          => $pi["id"],
    "amount"      => $pi["amount_received"] / 100,
    "currency"    => strtoupper($pi["currency"]),
    "status"      => $pi["status"],
    "created"     => $pi["created"],

    "customer"    => json_decode($pi["metadata"]["customer"] ?? "{}", true),
    "items"       => $items,
    "dropship"    => json_decode($pi["metadata"]["dropship"] ?? "{}", true),

    "raw"         => $pi
];

echo json_encode($response);
