<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$id = $_GET["id"] ?? null;

if (!$id) {
    echo json_encode(["status" => false, "message" => "Missing order ID"]);
    exit;
}

$file = __DIR__ . "/orders.json";

if (!file_exists($file)) {
    echo json_encode(["status" => false, "message" => "No orders found"]);
    exit;
}

$orders = json_decode(file_get_contents($file), true);
if (!is_array($orders)) $orders = [];

foreach ($orders as $order) {
    if ($order["id"] == $id) {
        echo json_encode([
            "status" => true,
            "order"  => $order
        ]);
        exit;
    }
}

echo json_encode([
    "status" => false,
    "message" => "Order not found"
]);
