<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *"); 
header("Access-Control-Allow-Headers: *");

$productsFile  = __DIR__ . "/products.json";
$categoriesFile = __DIR__ . "/categories.json";
$configFile     = __DIR__ . "/config.json";

// ===============================
// AUTO CREATE FILES
// ===============================
if (!file_exists($productsFile))  file_put_contents($productsFile, json_encode([], JSON_PRETTY_PRINT));
if (!file_exists($categoriesFile)) file_put_contents($categoriesFile, json_encode([], JSON_PRETTY_PRINT));
if (!file_exists($configFile)) {
    file_put_contents($configFile, json_encode([
        "site_name"        => "NOIR.",
        "accent"           => "#FFD700",
        "font_color"       => "#000000",
        "custom_head"        => "",
        "custom_body_top"    => "",
        "custom_body_bottom" => "",
        "custom_footer"      => ""
    ], JSON_PRETTY_PRINT));
}

// ===============================
// LOAD JSON
// ===============================
$products   = json_decode(file_get_contents($productsFile), true);
$categories = json_decode(file_get_contents($categoriesFile), true);
$config     = json_decode(file_get_contents($configFile), true);

if (!is_array($products))   $products = [];
if (!is_array($categories)) $categories = [];
if (!is_array($config))     $config = [];

// Ensure config keys exist
$config = array_merge($config, [
    "site_name"        => $config["site_name"]        ?? "NOIR.",
    "accent"           => $config["accent"]           ?? "#FFD700",
    "font_color"       => $config["font_color"]       ?? "#000000",
    "custom_head"        => $config["custom_head"]        ?? "",
    "custom_body_top"    => $config["custom_body_top"]    ?? "",
    "custom_body_bottom" => $config["custom_body_bottom"] ?? "",
    "custom_footer"      => $config["custom_footer"]      ?? "",
    "footer_copyright"   => $config["footer_copyright"]   ?? "© 2025 Experience",
]);

// =============================================
// NORMALIZE PRODUCT STRUCTURE
// =============================================
foreach ($products as &$p) {

    // IMAGES
    if (!isset($p["images"])) {
        if (isset($p["img"]))       $p["images"] = [$p["img"]];
        elseif (isset($p["image"])) $p["images"] = [$p["image"]];
        elseif (isset($p["gallery"]) && is_array($p["gallery"])) 
            $p["images"] = $p["gallery"];
        else 
            $p["images"] = [];
    }

    // VARIANTS
    if (!isset($p["variants"])) {
        $p["variants"] = [
            "colors" => isset($p["colors"]) ? $p["colors"] : [],
            "sizes"  => isset($p["sizes"])  ? $p["sizes"]  : []
        ];
    }

    // REMOVE OLD KEYS
    unset($p["img"], $p["image"], $p["gallery"], $p["colors"], $p["sizes"]);
}

// Force variants format correct
if (isset($p["variants"]["colors"])) {
    foreach ($p["variants"]["colors"] as &$c) {
        if (!isset($c["hex"]) || !str_starts_with($c["hex"], "#")) {
            // invalid entry, remove
            $c = null;
        }
    }
    $p["variants"]["colors"] = array_values(array_filter($p["variants"]["colors"]));
}

// ===============================
// FILTER BY CATEGORY
// ===============================
$filterCat = isset($_GET["cat"]) ? strtolower(trim($_GET["cat"])) : null;

if ($filterCat) {
    $products = array_values(array_filter($products, function($p) use ($filterCat) {
        return isset($p["category"]) && strtolower($p["category"]) === $filterCat;
    }));
}

// ===============================
// OUTPUT JSON
// ===============================
echo json_encode([
    "status" => true,
    "products" => $products,
    "categories" => $categories,
    "config" => $config
]);
