<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$file = __DIR__ . "/orders.json";

/* =========================================
   1. Ensure file exists
========================================= */
if (!file_exists($file)) {
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
}

/* =========================================
   2. Load JSON safely
========================================= */
$raw = file_get_contents($file);
$data = json_decode($raw, true);

if (!is_array($data)) {
    // Auto repair JSON corruption — NEVER crash store
    $data = [];
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
}

/* =========================================
   3. Sort newest → oldest
========================================= */
usort($data, function($a, $b) {
    return ($b["timestamp"] ?? 0) - ($a["timestamp"] ?? 0);
});

/* =========================================
   4. Support optional pagination
      ?page=1&limit=20
========================================= */
$page  = isset($_GET['page']) ? max(1, intval($_GET['page'])) : 1;
$limit = isset($_GET['limit']) ? max(1, intval($_GET['limit'])) : 200; // default 200 orders

$offset = ($page - 1) * $limit;
$paginated = array_slice($data, $offset, $limit);

/* =========================================
   5. Response
========================================= */
echo json_encode([
    "status" => true,
    "count"  => count($data),
    "page"   => $page,
    "limit"  => $limit,
    "data"   => $paginated
], JSON_PRETTY_PRINT);
