<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");

$file = __DIR__ . "/config.json";

if (!file_exists($file)) {
    file_put_contents($file, json_encode([
        "brand"   => "My Store",
        "tagline" => "",
        "accent"  => "#d4af37",
        "footer"  => "© 2025 My Store",
        "logo"    => "",
        "theme"   => "light"
    ], JSON_PRETTY_PRINT));
}

$data = json_decode(file_get_contents($file), true);
if (!is_array($data)) $data = [];

echo json_encode([
    "status" => true,
    "config" => $data
]);
