<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: POST");

$productsFile = __DIR__ . "/products.json";

// ===============================
// 1. Pastikan file ada
// ===============================
if (!file_exists($productsFile)) {
    file_put_contents($productsFile, json_encode([], JSON_PRETTY_PRINT));
}

$products = json_decode(file_get_contents($productsFile), true);
if (!is_array($products)) $products = [];

// ===============================
// 2. Ambil request JSON
// ===============================
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data || !isset($data["id"])) {
    echo json_encode([
        "status" => false,
        "message" => "Missing product ID."
    ]);
    exit;
}

$id = intval($data["id"]);

// ===============================
// 3. Cari & hapus produk
// ===============================
$found = false;

foreach ($products as $key => $p) {
    if ($p["id"] == $id) {
        unset($products[$key]);
        $found = true;
        break;
    }
}

if (!$found) {
    echo json_encode([
        "status" => false,
        "message" => "Product not found."
    ]);
    exit;
}

// Reset array index
$products = array_values($products);

// Simpan ulang file
file_put_contents($productsFile, json_encode($products, JSON_PRETTY_PRINT));

// ===============================
// 4. Beri response sukses
// ===============================
echo json_encode([
    "status" => true,
    "message" => "Product deleted successfully.",
    "products" => $products
]);
