<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");
header("Access-Control-Allow-Methods: POST");

$file = __DIR__ . "/categories.json";

// ===============================
// 1. Pastikan file kategori ada
// ===============================
if (!file_exists($file)) {
    file_put_contents($file, json_encode([], JSON_PRETTY_PRINT));
}

$list = json_decode(file_get_contents($file), true);
if (!is_array($list)) $list = [];

// ===============================
// 2. Ambil request JSON
// ===============================
$raw = file_get_contents("php://input");
$req = json_decode($raw, true);

if (!$req || !isset($req["id"])) {
    echo json_encode([
        "status" => false,
        "message" => "Category ID is required."
    ]);
    exit;
}

$id = intval($req["id"]);

// ===============================
// 3. Cari & hapus kategori
// ===============================
$found = false;
$newList = [];

foreach ($list as $cat) {
    if ($cat["id"] == $id) {
        $found = true;
        continue;
    }
    $newList[] = $cat;
}

// ===============================
// 4. Kategori tidak ditemukan
// ===============================
if (!$found) {
    echo json_encode([
        "status" => false,
        "message" => "Category not found."
    ]);
    exit;
}

// ===============================
// 5. Simpan perubahan
// ===============================
file_put_contents($file, json_encode($newList, JSON_PRETTY_PRINT));

echo json_encode([
    "status" => true,
    "message" => "Category deleted.",
    "categories" => $newList
]);
