<?php
header("Content-Type: application/json");
header("Access-Control-Allow-Origin: *");
header("Access-Control-Allow-Headers: *");

$stripeSecret = "sk_test_51SbFDrFawUqu0aCku1bvrTb3aSABnDDfdcsXT5ziFbx0ujBpuYV90gCKew1cjrGwa4B0rVgsKAZTzDKzpz5vZ3K3002d6iDM7U";

// Read JSON
$raw = file_get_contents("php://input");
$data = json_decode($raw, true);

if (!$data || !isset($data["total"])) {
    echo json_encode(["error" => "Invalid payload"]);
    exit;
}

$total = intval($data["total"]) * 100; // USD cents

// Prepare metadata (Stripe will show this on dashboard)
$meta = [
    "customer"     => json_encode($data["customer"]),
    "dropship"     => json_encode($data["dropship"]),
    "items"        => json_encode($data["items"]) // sudah termasuk color & size
];

$fields = [
    "amount" => $total,
    "currency" => "usd",
    "automatic_payment_methods[enabled]" => "true"
];

foreach ($meta as $k => $v) {
    $fields["metadata[$k]"] = $v;
}

$ch = curl_init("https://api.stripe.com/v1/payment_intents");

curl_setopt_array($ch, [
    CURLOPT_RETURNTRANSFER => true,
    CURLOPT_POST => true,
    CURLOPT_USERPWD => $stripeSecret . ":",
    CURLOPT_POSTFIELDS => http_build_query($fields)
]);

$res = curl_exec($ch);
$http = curl_getinfo($ch, CURLINFO_HTTP_CODE);
curl_close($ch);

if ($http >= 400) {
    echo json_encode([
        "error" => "Stripe error",
        "http"  => $http,
        "raw"   => json_decode($res, true)
    ]);
    exit;
}

// SUCCESS
echo $res;
